// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanAsrouterMetrics_h
#define mozilla_GleanAsrouterMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace messaging_system {
  /**
   * generated from messaging_system.addon_version
   * Used to hold the system addon's version, now is almost certainly an echo of the app's build id.
   */
  constexpr impl::StringMetric addon_version(211);

  /**
   * generated from messaging_system.browser_session_id
   * The Legacy Telemetry browser "session id". Identifies a specific period from application start to shutdown. See [the "main" ping docs](https://firefox-source-docs.mozilla.org/toolkit/components/telemetry/data/main-ping.html) for details.
   */
  constexpr impl::UuidMetric browser_session_id(212);

  /**
   * generated from messaging_system.bucket_id
   * A name shared between multiple messages that may individually be too targetted. e.g. a message that gets shown on specific websites or a message asking about personal information.
   */
  constexpr impl::StringMetric bucket_id(213);

  /**
   * generated from messaging_system.client_id
   * The client_id according to Telemetry.
   * Might not always have a value due to policy around specific types of
   * ping being sent. Value may be the canary client id
   * `c0ffeec0-ffee-c0ff-eec0-ffeec0ffeec0`
   * in pings near when the data upload pref is disabled (if Telemetry gets
   * to go first), or between when a client_id has been removed and when it
   * has been regenerated.
   * Present only in some circumstances (see
   * [bug 1484035]https://bugzilla.mozilla.org/show_bug.cgi?id=1484035)).
   */
  constexpr impl::UuidMetric client_id(214);

  /**
   * generated from messaging_system.event
   * The type of event. Any user defined string (e.g. “IMPRESSION”, “CLICK_BUTTON”, "INDEXEDDB_OPEN_FAILED", “SESSION_END”)
   */
  constexpr impl::StringMetric event(215);

  /**
   * generated from messaging_system.event_context
   * The stringified JSON of `event_context`.
   */
  constexpr impl::TextMetric event_context(216);

  /**
   * generated from messaging_system.event_context_parse_error
   * How often we failed to parse event_context as JSON.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> event_context_parse_error(217);

  /**
   * generated from messaging_system.event_page
   * The event_context's `page`. Almost always "about:welcome".
   */
  constexpr impl::StringMetric event_page(218);

  /**
   * generated from messaging_system.event_reason
   * The event_context's `reason`. Likely something like
   * "welcome-window-closed" or "app-shut-down",.
   */
  constexpr impl::StringMetric event_reason(219);

  /**
   * generated from messaging_system.event_screen_family
   * A string identifier of the message family derived from the message id
   * (e.g. MR_WELCOME_DEFAULT).
   */
  constexpr impl::TextMetric event_screen_family(220);

  /**
   * generated from messaging_system.event_screen_id
   * A string identifier of the message screen id
   * (e.g. AW_MOBILE_DOWNLOAD).
   */
  constexpr impl::TextMetric event_screen_id(221);

  /**
   * generated from messaging_system.event_screen_index
   * A number identifier of the screen index in a sequence of screens
   * (e.g. 0 for first message).
   */
  constexpr impl::QuantityMetric event_screen_index(222);

  /**
   * generated from messaging_system.event_screen_initials
   * A string identifier of the message screen initials
   * (e.g. 'EMAG' for EASY_SETUP, MOBILE_DOWNLOADS, AMO, GRATITUDE).
   */
  constexpr impl::TextMetric event_screen_initials(223);

  /**
   * generated from messaging_system.event_source
   * The event_context's `source`. Likely something like "primary_button".
   */
  constexpr impl::StringMetric event_source(224);

  /**
   * generated from messaging_system.glean_ping_for_ping_failures
   * How often something went awry within
   * `AboutWelcome.submitGleanPingForPing`, preventing ping submission.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> glean_ping_for_ping_failures(225);

  /**
   * generated from messaging_system.impression_id
   * The unique impression identifier for a specific client.
   */
  constexpr impl::UuidMetric impression_id(226);

  /**
   * generated from messaging_system.invalid_nested_data
   * We received a ping with non-scalar data on a field of this name.
   * If this is existing pre-PingCentre-replacement data, you may need to
   * augment the logic in
   * `AboutWelcome.submitGleanPingForPing` like the other `handledKeys`.
   * If this is for new, post-PingCentre-replacement data, you should
   * probably prefer a flat structure.
   * If you're unsure, please ask in
   * [the #glean channel](https://chat.mozilla.org/#/room/#glean:mozilla.org).
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> invalid_nested_data(227);

  /**
   * generated from messaging_system.locale
   * The locale as supplied to the messaging system by `Services.locale.appLocaleAsBCP47`.
   */
  constexpr impl::StringMetric locale(228);

  /**
   * generated from messaging_system.message_id
   * A string identifier of the message in Activity Stream Router.
   */
  constexpr impl::TextMetric message_id(229);

  /**
   * generated from messaging_system.message_request_time
   * Firefox: Time in ms spent selecting and matching messages to user profile.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram MS_MESSAGE_REQUEST_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric message_request_time(230);

  /**
   * generated from messaging_system.ping_type
   * Type of event the ping is capturing. e.g. "cfr", "onboarding"
   */
  constexpr impl::StringMetric ping_type(231);

  /**
   * generated from messaging_system.source
   * The source of the interaction described by the other metrics. e.g. "frecent_links", "newtab", "CFR"
   */
  constexpr impl::StringMetric source(232);

  /**
   * generated from messaging_system.unknown_key_count
   * The sum of all unknown keys counted.
   * Useful for testing.
   * Can be removed after bug 1600008 is resolved.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> unknown_key_count(233);

  /**
   * generated from messaging_system.unknown_keys
   * Ping keys supplied to the messaging system for which
   * we did not have a corresponding metric mapped to how often they attempted
   * to be recorded.
   * You may have forgotten to define an appropriate metric in
   * `browser/components/newtab/metrics.yaml`.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> unknown_keys(234);
}

namespace messaging_system_attribution {
  /**
   * generated from messaging_system.attribution.campaign
   * Attribution's campaign, possibly derived from the utm parameter of the
   * same name.
   */
  constexpr impl::StringMetric campaign(235);

  /**
   * generated from messaging_system.attribution.content
   * Attribution's content, possibly derived from the utm parameter of the
   * same name.
   */
  constexpr impl::StringMetric content(236);

  /**
   * generated from messaging_system.attribution.dlsource
   * Mozilla-specific download "source" name. Could be something like
   * "mozillaci" to identify that the installer came from
   * `{archive|ftp}.mozilla.org`.
   */
  constexpr impl::StringMetric dlsource(237);

  /**
   * generated from messaging_system.attribution.dltoken
   * String representation of the dltoken identifying the particular
   * installer used to install this Firefox.
   * Likely a UUID, if present.
   */
  constexpr impl::StringMetric dltoken(238);

  /**
   * generated from messaging_system.attribution.experiment
   * Attribution's experiment key.
   */
  constexpr impl::StringMetric experiment(239);

  /**
   * generated from messaging_system.attribution.medium
   * Attribution's medium, possibly derived from the utm parameter of the same
   * name.
   */
  constexpr impl::StringMetric medium(240);

  /**
   * generated from messaging_system.attribution.msstoresignedin
   * Either the string "true" or the string "false" to indicate whether the
   * attributed install came from the Microsoft store and, if so, whether the
   * user was signed in at the time.
   */
  constexpr impl::StringMetric msstoresignedin(241);

  /**
   * generated from messaging_system.attribution.source
   * Attribution's source, possibly derived from the utm parameter of the same
   * name.
   */
  constexpr impl::StringMetric source(242);

  /**
   * generated from messaging_system.attribution.ua
   * Attribution's ua key.
   */
  constexpr impl::StringMetric ua(243);

  /**
   * generated from messaging_system.attribution.unknown_keys
   * Attribution keys supplied to the messaging system for which
   * we did not have a corresponding metric, and the count of how
   * often that happened.
   * Either add this key to a list of known attribution keys in
   * `AboutWelcomeTelemetry` to suppress or define an appropriate metric in
   * `browser/components/newtab/metrics.yaml` to collect.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> unknown_keys(244);

  /**
   * generated from messaging_system.attribution.variation
   * Attribution's variation key.
   */
  constexpr impl::StringMetric variation(245);
}

} // namespace mozilla::glean

#endif // mozilla_GleanAsrouterMetrics_h
