#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSS2Properties = 885,
  CSSAnimation = 900,
  CSSConditionRule = 913,
  CSSContainerRule = 930,
  CSSCounterStyleRule = 947,
  CSSCustomPropertyRegisteredEvent = 967,
  CSSFontFaceRule = 1000,
  CSSFontFeatureValuesRule = 1016,
  CSSFontPaletteValuesRule = 1041,
  CSSGroupingRule = 1066,
  CSSImportRule = 1082,
  CSSKeyframeRule = 1096,
  CSSKeyframesRule = 1112,
  CSSLayerBlockRule = 1129,
  CSSLayerStatementRule = 1147,
  CSSMarginRule = 1169,
  CSSMediaRule = 1183,
  CSSMozDocumentRule = 1196,
  CSSNamespaceRule = 1215,
  CSSNestedDeclarations = 1232,
  CSSPageDescriptors = 1254,
  CSSPageRule = 1273,
  CSSPositionTryDescriptors = 1285,
  CSSPositionTryRule = 1311,
  CSSPropertyRule = 1330,
  CSSPseudoElement = 1346,
  CSSRule = 1363,
  CSSRuleList = 1371,
  CSSScopeRule = 1383,
  CSSStartingStyleRule = 1396,
  CSSStyleDeclaration = 1417,
  CSSStyleRule = 1437,
  CSSStyleSheet = 1450,
  CSSSupportsRule = 1464,
  CSSTransition = 1480,
  Cache = 1494,
  CacheStorage = 1500,
  CallbackDebuggerNotification = 1513,
  CanonicalBrowsingContext = 1542,
  CanvasCaptureMediaStream = 1567,
  CanvasGradient = 1592,
  CanvasPattern = 1607,
  CanvasRenderingContext2D = 1621,
  CaretPosition = 1646,
  CaretStateChangedEvent = 1660,
  ChannelMergerNode = 1683,
  ChannelSplitterNode = 1701,
  ChannelWrapper = 1721,
  CharacterData = 1736,
  CheckerboardReportService = 1750,
  ChildProcessMessageManager = 1776,
  ChildSHistory = 1803,
  ChromeMessageBroadcaster = 1817,
  ChromeMessageSender = 1842,
  ChromeNodeList = 1862,
  ChromeUtils = 1877,
  ChromeWorker = 1889,
  Client = 1902,
  Clients = 1909,
  Clipboard = 1917,
  ClipboardEvent = 1927,
  ClipboardItem = 1942,
  ClonedErrorHolder = 1956,
  CloseEvent = 1974,
  CloseWatcher = 1985,
  CommandEvent = 1998,
  Comment = 2011,
  CompositionEvent = 2019,
  CompressionStream = 2036,
  ConsoleInstance = 2054,
  ConstantSourceNode = 2070,
  ContentFrameMessageManager = 2089,
  ContentProcessMessageManager = 2116,
  ContentVisibilityAutoStateChangeEvent = 2145,
  ConvolverNode = 2183,
  CookieChangeEvent = 2197,
  CookieStore = 2215,
  CookieStoreManager = 2227,
  CountQueuingStrategy = 2246,
  CreateOfferRequest = 2267,
  Credential = 2286,
  CredentialsContainer = 2297,
  Crypto = 2318,
  CryptoKey = 2325,
  CustomElementRegistry = 2335,
  CustomEvent = 2357,
  CustomStateSet = 2369,
  DOMException = 2384,
  DOMImplementation = 2397,
  DOMLocalization = 2415,
  DOMMatrix = 2431,
  DOMMatrixReadOnly = 2441,
  DOMParser = 2459,
  DOMPoint = 2469,
  DOMPointReadOnly = 2478,
  DOMQuad = 2495,
  DOMRect = 2503,
  DOMRectList = 2511,
  DOMRectReadOnly = 2523,
  DOMStringList = 2539,
  DOMStringMap = 2553,
  DOMTokenList = 2566,
  DataTransfer = 2579,
  DataTransferItem = 2592,
  DataTransferItemList = 2609,
  DebuggerNotification = 2630,
  DebuggerNotificationObserver = 2651,
  DecompressionStream = 2680,
  DedicatedWorkerGlobalScope = 2700,
  DelayNode = 2727,
  DeprecationReportBody = 2737,
  DeviceAcceleration = 2759,
  DeviceLightEvent = 2778,
  DeviceMotionEvent = 2795,
  DeviceOrientationEvent = 2813,
  DeviceRotationRate = 2836,
  Directory = 2855,
  Document = 2865,
  DocumentFragment = 2874,
  DocumentL10n = 2891,
  DocumentTimeline = 2904,
  DocumentType = 2921,
  DominatorTree = 2934,
  DragEvent = 2948,
  DynamicsCompressorNode = 2958,
  EXT_blend_minmax = 2981,
  EXT_color_buffer_float = 2998,
  EXT_color_buffer_half_float = 3021,
  EXT_depth_clamp = 3049,
  EXT_disjoint_timer_query = 3065,
  EXT_float_blend = 3090,
  EXT_frag_depth = 3106,
  EXT_sRGB = 3121,
  EXT_shader_texture_lod = 3130,
  EXT_texture_compression_bptc = 3153,
  EXT_texture_compression_rgtc = 3182,
  EXT_texture_filter_anisotropic = 3211,
  EXT_texture_norm16 = 3242,
  Element = 3261,
  ElementInternals = 3269,
  EncodedAudioChunk = 3286,
  EncodedVideoChunk = 3304,
  ErrorEvent = 3322,
  Event = 3333,
  EventCallbackDebuggerNotification = 3339,
  EventCounts = 3373,
  EventSource = 3385,
  EventTarget = 3397,
  Exception = 3409,
  ExtendableCookieChangeEvent = 3419,
  ExtendableEvent = 3447,
  ExtendableMessageEvent = 3463,
  ExtensionAlarms = 3486,
  ExtensionBrowser = 3502,
  ExtensionBrowserSettings = 3519,
  ExtensionBrowserSettingsColorManagement = 3544,
  ExtensionDns = 3584,
  ExtensionEventManager = 3597,
  ExtensionMockAPI = 3619,
  ExtensionPort = 3636,
  ExtensionProxy = 3650,
  ExtensionRuntime = 3665,
  ExtensionScripting = 3682,
  ExtensionSetting = 3701,
  ExtensionTest = 3718,
  External = 3732,
  FeaturePolicy = 3741,
  FeaturePolicyViolationReportBody = 3755,
  FetchEvent = 3788,
  FetchObserver = 3799,
  File = 3813,
  FileList = 3818,
  FileReader = 3827,
  FileReaderSync = 3838,
  FileSystem = 3853,
  FileSystemDirectoryEntry = 3864,
  FileSystemDirectoryHandle = 3889,
  FileSystemDirectoryHandle_AsyncIterator = 3915,
  FileSystemDirectoryIterator = 3955,
  FileSystemDirectoryReader = 3983,
  FileSystemEntry = 4009,
  FileSystemFileEntry = 4025,
  FileSystemFileHandle = 4045,
  FileSystemHandle = 4066,
  FileSystemSyncAccessHandle = 4083,
  FileSystemWritableFileStream = 4110,
  Flex = 4139,
  FlexItemValues = 4144,
  FlexLineValues = 4159,
  FluentBundle = 4174,
  FluentBundleAsyncIterator = 4187,
  FluentBundleIterator = 4213,
  FluentPattern = 4234,
  FluentResource = 4248,
  FocusEvent = 4263,
  FontFace = 4274,
  FontFaceSet = 4283,
  FontFaceSetIterator = 4295,
  FontFaceSetLoadEvent = 4315,
  FormData = 4336,
  FormData_Iterator = 4345,
  FormDataEvent = 4363,
  FragmentDirective = 4377,
  FrameCrashedEvent = 4395,
  FrameLoader = 4413,
  GPU = 4425,
  GPUAdapter = 4429,
  GPUAdapterInfo = 4440,
  GPUBindGroup = 4455,
  GPUBindGroupLayout = 4468,
  GPUBuffer = 4487,
  GPUBufferUsage = 4497,
  GPUCanvasContext = 4512,
  GPUColorWrite = 4529,
  GPUCommandBuffer = 4543,
  GPUCommandEncoder = 4560,
  GPUCompilationInfo = 4578,
  GPUCompilationMessage = 4597,
  GPUComputePassEncoder = 4619,
  GPUComputePipeline = 4641,
  GPUDevice = 4660,
  GPUDeviceLostInfo = 4670,
  GPUError = 4688,
  GPUExternalTexture = 4697,
  GPUInternalError = 4716,
  GPUMapMode = 4733,
  GPUOutOfMemoryError = 4744,
  GPUPipelineError = 4764,
  GPUPipelineLayout = 4781,
  GPUQuerySet = 4799,
  GPUQueue = 4811,
  GPURenderBundle = 4820,
  GPURenderBundleEncoder = 4836,
  GPURenderPassEncoder = 4859,
  GPURenderPipeline = 4880,
  GPUSampler = 4898,
  GPUShaderModule = 4909,
  GPUShaderStage = 4925,
  GPUSupportedFeatures = 4940,
  GPUSupportedLimits = 4961,
  GPUTexture = 4980,
  GPUTextureUsage = 4991,
  GPUTextureView = 5007,
  GPUUncapturedErrorEvent = 5022,
  GPUValidationError = 5046,
  GainNode = 5065,
  Gamepad = 5074,
  GamepadAxisMoveEvent = 5082,
  GamepadButton = 5103,
  GamepadButtonEvent = 5117,
  GamepadEvent = 5136,
  GamepadHapticActuator = 5149,
  GamepadLightIndicator = 5171,
  GamepadPose = 5193,
  GamepadServiceTest = 5205,
  GamepadTouch = 5224,
  Geolocation = 5237,
  GeolocationCoordinates = 5249,
  GeolocationPosition = 5272,
  GeolocationPositionError = 5292,
  GetUserMediaRequest = 5317,
  GleanBoolean = 5337,
  GleanCategory = 5350,
  GleanCounter = 5364,
  GleanCustomDistribution = 5377,
  GleanDatetime = 5401,
  GleanDenominator = 5415,
  GleanEvent = 5432,
  GleanImpl = 5443,
  GleanLabeled = 5453,
  GleanMemoryDistribution = 5466,
  GleanMetric = 5490,
  GleanNumerator = 5502,
  GleanObject = 5517,
  GleanPingsImpl = 5529,
  GleanQuantity = 5544,
  GleanRate = 5558,
  GleanString = 5568,
  GleanStringList = 5580,
  GleanText = 5596,
  GleanTimespan = 5606,
  GleanTimingDistribution = 5620,
  GleanUrl = 5644,
  GleanUuid = 5653,
  Grid = 5663,
  GridArea = 5668,
  GridDimension = 5677,
  GridLine = 5691,
  GridLines = 5700,
  GridTrack = 5710,
  GridTracks = 5720,
  HTMLAllCollection = 5731,
  HTMLAnchorElement = 5749,
  HTMLAreaElement = 5767,
  HTMLAudioElement = 5783,
  HTMLBRElement = 5800,
  HTMLBaseElement = 5814,
  HTMLBodyElement = 5830,
  HTMLButtonElement = 5846,
  HTMLCanvasElement = 5864,
  HTMLCollection = 5882,
  HTMLDListElement = 5897,
  HTMLDataElement = 5914,
  HTMLDataListElement = 5930,
  HTMLDetailsElement = 5950,
  HTMLDialogElement = 5969,
  HTMLDirectoryElement = 5987,
  HTMLDivElement = 6008,
  HTMLDocument = 6023,
  HTMLElement = 6036,
  HTMLEmbedElement = 6048,
  HTMLFieldSetElement = 6065,
  HTMLFontElement = 6085,
  HTMLFormControlsCollection = 6101,
  HTMLFormElement = 6128,
  HTMLFrameElement = 6144,
  HTMLFrameSetElement = 6161,
  HTMLHRElement = 6181,
  HTMLHeadElement = 6195,
  HTMLHeadingElement = 6211,
  HTMLHtmlElement = 6230,
  HTMLIFrameElement = 6246,
  HTMLImageElement = 6264,
  HTMLInputElement = 6281,
  HTMLLIElement = 6298,
  HTMLLabelElement = 6312,
  HTMLLegendElement = 6329,
  HTMLLinkElement = 6347,
  HTMLMapElement = 6363,
  HTMLMarqueeElement = 6378,
  HTMLMediaElement = 6397,
  HTMLMenuElement = 6414,
  HTMLMetaElement = 6430,
  HTMLMeterElement = 6446,
  HTMLModElement = 6463,
  HTMLOListElement = 6478,
  HTMLObjectElement = 6495,
  HTMLOptGroupElement = 6513,
  HTMLOptionElement = 6533,
  HTMLOptionsCollection = 6551,
  HTMLOutputElement = 6573,
  HTMLParagraphElement = 6591,
  HTMLParamElement = 6612,
  HTMLPictureElement = 6629,
  HTMLPreElement = 6648,
  HTMLProgressElement = 6663,
  HTMLQuoteElement = 6683,
  HTMLScriptElement = 6700,
  HTMLSelectElement = 6718,
  HTMLSlotElement = 6736,
  HTMLSourceElement = 6752,
  HTMLSpanElement = 6770,
  HTMLStyleElement = 6786,
  HTMLTableCaptionElement = 6803,
  HTMLTableCellElement = 6827,
  HTMLTableColElement = 6848,
  HTMLTableElement = 6868,
  HTMLTableRowElement = 6885,
  HTMLTableSectionElement = 6905,
  HTMLTemplateElement = 6929,
  HTMLTextAreaElement = 6949,
  HTMLTimeElement = 6969,
  HTMLTitleElement = 6985,
  HTMLTrackElement = 7002,
  HTMLUListElement = 7019,
  HTMLUnknownElement = 7036,
  HTMLVideoElement = 7055,
  HashChangeEvent = 7072,
  Headers = 7088,
  Headers_Iterator = 7096,
  HeapSnapshot = 7113,
  Highlight = 7126,
  HighlightRegistry = 7136,
  History = 7154,
  IDBCursor = 7162,
  IDBCursorWithValue = 7172,
  IDBDatabase = 7191,
  IDBFactory = 7203,
  IDBIndex = 7214,
  IDBKeyRange = 7223,
  IDBObjectStore = 7235,
  IDBOpenDBRequest = 7250,
  IDBRequest = 7267,
  IDBTransaction = 7278,
  IDBVersionChangeEvent = 7293,
  IIRFilterNode = 7315,
  IOUtils = 7329,
  IdentityCredential = 7337,
  IdleDeadline = 7356,
  Image = 7369,
  ImageBitmap = 7375,
  ImageBitmapRenderingContext = 7387,
  ImageCapture = 7415,
  ImageCaptureError = 7428,
  ImageCaptureErrorEvent = 7446,
  ImageData = 7469,
  ImageDecoder = 7479,
  ImageDocument = 7492,
  ImageTrack = 7506,
  ImageTrackList = 7517,
  InputEvent = 7532,
  InspectorCSSParser = 7543,
  InspectorFontFace = 7562,
  InspectorUtils = 7580,
  InstallTriggerImpl = 7595,
  IntersectionObserver = 7614,
  IntersectionObserverEntry = 7635,
  IntlUtils = 7661,
  InvokeEvent = 7671,
  JSProcessActorChild = 7683,
  JSProcessActorParent = 7703,
  JSWindowActorChild = 7724,
  JSWindowActorParent = 7743,
  KeyEvent = 7763,
  KeyboardEvent = 7772,
  KeyframeEffect = 7786,
  L10nFileSource = 7801,
  L10nOverlays = 7816,
  L10nRegistry = 7829,
  LargestContentfulPaint = 7842,
  LegacyMozTCPSocket = 7865,
  Localization = 7884,
  Location = 7897,
  Lock = 7906,
  LockManager = 7911,
  MIDIAccess = 7923,
  MIDIConnectionEvent = 7934,
  MIDIInput = 7954,
  MIDIInputMap = 7964,
  MIDIMessageEvent = 7977,
  MIDIOutput = 7994,
  MIDIOutputMap = 8005,
  MIDIPort = 8019,
  MLS = 8028,
  MLSGroupView = 8032,
  MOZ_debug = 8045,
  MatchGlob = 8055,
  MatchPattern = 8065,
  MatchPatternSet = 8078,
  MathMLElement = 8094,
  MediaCapabilities = 8108,
  MediaControlService = 8126,
  MediaController = 8146,
  MediaDeviceInfo = 8162,
  MediaDevices = 8178,
  MediaElementAudioSourceNode = 8191,
  MediaEncryptedEvent = 8219,
  MediaError = 8239,
  MediaKeyError = 8250,
  MediaKeyMessageEvent = 8264,
  MediaKeySession = 8285,
  MediaKeyStatusMap = 8301,
  MediaKeyStatusMap_Iterator = 8319,
  MediaKeySystemAccess = 8346,
  MediaKeys = 8367,
  MediaList = 8377,
  MediaMetadata = 8387,
  MediaQueryList = 8401,
  MediaQueryListEvent = 8416,
  MediaRecorder = 8436,
  MediaRecorderErrorEvent = 8450,
  MediaSession = 8474,
  MediaSource = 8487,
  MediaStream = 8499,
  MediaStreamAudioDestinationNode = 8511,
  MediaStreamAudioSourceNode = 8543,
  MediaStreamError = 8570,
  MediaStreamEvent = 8587,
  MediaStreamTrack = 8604,
  MediaStreamTrackAudioSourceNode = 8621,
  MediaStreamTrackEvent = 8653,
  MerchantValidationEvent = 8675,
  MessageBroadcaster = 8699,
  MessageChannel = 8718,
  MessageEvent = 8733,
  MessageListenerManager = 8746,
  MessagePort = 8769,
  MessageSender = 8781,
  MimeType = 8795,
  MimeTypeArray = 8804,
  MouseEvent = 8818,
  MouseScrollEvent = 8829,
  MozCanvasPrintState = 8846,
  MozDocumentMatcher = 8866,
  MozDocumentObserver = 8885,
  MozQueryInterface = 8905,
  MozSharedMap = 8923,
  MozSharedMap_Iterator = 8936,
  MozSharedMapChangeEvent = 8958,
  MozStorageAsyncStatementParams = 8982,
  MozStorageStatementParams = 9013,
  MozStorageStatementRow = 9039,
  MozWritableSharedMap = 9062,
  MutationEvent = 9083,
  MutationObserver = 9097,
  MutationRecord = 9114,
  NamedNodeMap = 9129,
  NavigateEvent = 9142,
  Navigation = 9156,
  NavigationActivation = 9167,
  NavigationCurrentEntryChangeEvent = 9188,
  NavigationDestination = 9222,
  NavigationHistoryEntry = 9244,
  NavigationPreloadManager = 9267,
  NavigationTransition = 9292,
  Navigator = 9313,
  NavigatorLogin = 9323,
  NetworkInformation = 9338,
  Node = 9357,
  NodeFilter = 9362,
  NodeIterator = 9373,
  NodeList = 9386,
  Notification = 9395,
  NotificationEvent = 9408,
  NotifyPaintEvent = 9426,
  OES_draw_buffers_indexed = 9443,
  OES_element_index_uint = 9468,
  OES_fbo_render_mipmap = 9491,
  OES_standard_derivatives = 9513,
  OES_texture_float = 9538,
  OES_texture_float_linear = 9556,
  OES_texture_half_float = 9581,
  OES_texture_half_float_linear = 9604,
  OES_vertex_array_object = 9634,
  OVR_multiview2 = 9658,
  OfflineAudioCompletionEvent = 9673,
  OfflineAudioContext = 9701,
  OffscreenCanvas = 9721,
  OffscreenCanvasRenderingContext2D = 9737,
  Option = 9771,
  OscillatorNode = 9778,
  PageTransitionEvent = 9793,
  PaintRequest = 9813,
  PaintRequestList = 9826,
  PaintWorkletGlobalScope = 9843,
  PannerNode = 9867,
  ParentProcessMessageManager = 9878,
  Path2D = 9906,
  PathUtils = 9913,
  PaymentAddress = 9923,
  PaymentMethodChangeEvent = 9938,
  PaymentRequest = 9963,
  PaymentRequestUpdateEvent = 9978,
  PaymentResponse = 10004,
  PeerConnectionImpl = 10020,
  PeerConnectionObserver = 10039,
  Performance = 10062,
  PerformanceEntry = 10074,
  PerformanceEntryEvent = 10091,
  PerformanceEventTiming = 10113,
  PerformanceMark = 10136,
  PerformanceMeasure = 10152,
  PerformanceNavigation = 10171,
  PerformanceNavigationTiming = 10193,
  PerformanceObserver = 10221,
  PerformanceObserverEntryList = 10241,
  PerformancePaintTiming = 10270,
  PerformanceResourceTiming = 10293,
  PerformanceServerTiming = 10319,
  PerformanceTiming = 10343,
  PeriodicWave = 10361,
  PermissionStatus = 10374,
  Permissions = 10391,
  PlacesBookmark = 10403,
  PlacesBookmarkAddition = 10418,
  PlacesBookmarkChanged = 10441,
  PlacesBookmarkGuid = 10463,
  PlacesBookmarkKeyword = 10482,
  PlacesBookmarkMoved = 10504,
  PlacesBookmarkRemoved = 10524,
  PlacesBookmarkTags = 10546,
  PlacesBookmarkTime = 10565,
  PlacesBookmarkTitle = 10584,
  PlacesBookmarkUrl = 10604,
  PlacesEvent = 10622,
  PlacesEventCounts = 10634,
  PlacesFavicon = 10652,
  PlacesHistoryCleared = 10666,
  PlacesObservers = 10687,
  PlacesPurgeCaches = 10703,
  PlacesRanking = 10721,
  PlacesVisit = 10735,
  PlacesVisitRemoved = 10747,
  PlacesVisitTitle = 10766,
  PlacesWeakCallbackWrapper = 10783,
  Plugin = 10809,
  PluginArray = 10816,
  PluginCrashedEvent = 10828,
  PointerEvent = 10847,
  PopStateEvent = 10860,
  PopupBlockedEvent = 10874,
  PopupPositionedEvent = 10892,
  PositionStateEvent = 10913,
  PrecompiledScript = 10932,
  PrivateAttribution = 10950,
  ProcessMessageManager = 10969,
  ProcessingInstruction = 10991,
  ProgressEvent = 11013,
  PromiseDebugging = 11027,
  PromiseNativeHandler = 11044,
  PromiseRejectionEvent = 11065,
  PublicKeyCredential = 11087,
  PushEvent = 11107,
  PushManager = 11117,
  PushManagerImpl = 11129,
  PushMessageData = 11145,
  PushSubscription = 11161,
  PushSubscriptionChangeEvent = 11178,
  PushSubscriptionOptions = 11206,
  RTCCertificate = 11230,
  RTCDTMFSender = 11245,
  RTCDTMFToneChangeEvent = 11259,
  RTCDataChannel = 11282,
  RTCDataChannelEvent = 11297,
  RTCDtlsTransport = 11317,
  RTCEncodedAudioFrame = 11334,
  RTCEncodedVideoFrame = 11355,
  RTCIceCandidate = 11376,
  RTCIceTransport = 11392,
  RTCIdentityProviderRegistrar = 11408,
  RTCPeerConnection = 11437,
  RTCPeerConnectionIceEvent = 11455,
  RTCPeerConnectionStatic = 11481,
  RTCRtpReceiver = 11505,
  RTCRtpScriptTransform = 11520,
  RTCRtpScriptTransformer = 11542,
  RTCRtpSender = 11566,
  RTCRtpTransceiver = 11579,
  RTCSctpTransport = 11597,
  RTCSessionDescription = 11614,
  RTCStatsReport = 11636,
  RTCTrackEvent = 11651,
  RTCTransformEvent = 11665,
  RadioNodeList = 11683,
  Range = 11697,
  ReadableByteStreamController = 11703,
  ReadableStream = 11732,
  ReadableStream_AsyncIterator = 11747,
  ReadableStreamBYOBReader = 11776,
  ReadableStreamBYOBRequest = 11801,
  ReadableStreamDefaultController = 11827,
  ReadableStreamDefaultReader = 11859,
  Report = 11887,
  ReportBody = 11894,
  ReportingObserver = 11905,
  Request = 11923,
  ResizeObserver = 11931,
  ResizeObserverEntry = 11946,
  ResizeObserverSize = 11966,
  Response = 11985,
  SVGAElement = 11994,
  SVGAngle = 12006,
  SVGAnimateElement = 12015,
  SVGAnimateMotionElement = 12033,
  SVGAnimateTransformElement = 12057,
  SVGAnimatedAngle = 12084,
  SVGAnimatedBoolean = 12101,
  SVGAnimatedEnumeration = 12120,
  SVGAnimatedInteger = 12143,
  SVGAnimatedLength = 12162,
  SVGAnimatedLengthList = 12180,
  SVGAnimatedNumber = 12202,
  SVGAnimatedNumberList = 12220,
  SVGAnimatedPreserveAspectRatio = 12242,
  SVGAnimatedRect = 12273,
  SVGAnimatedString = 12289,
  SVGAnimatedTransformList = 12307,
  SVGAnimationElement = 12332,
  SVGCircleElement = 12352,
  SVGClipPathElement = 12369,
  SVGComponentTransferFunctionElement = 12388,
  SVGDefsElement = 12424,
  SVGDescElement = 12439,
  SVGElement = 12454,
  SVGEllipseElement = 12465,
  SVGFEBlendElement = 12483,
  SVGFEColorMatrixElement = 12501,
  SVGFEComponentTransferElement = 12525,
  SVGFECompositeElement = 12555,
  SVGFEConvolveMatrixElement = 12577,
  SVGFEDiffuseLightingElement = 12604,
  SVGFEDisplacementMapElement = 12632,
  SVGFEDistantLightElement = 12660,
  SVGFEDropShadowElement = 12685,
  SVGFEFloodElement = 12708,
  SVGFEFuncAElement = 12726,
  SVGFEFuncBElement = 12744,
  SVGFEFuncGElement = 12762,
  SVGFEFuncRElement = 12780,
  SVGFEGaussianBlurElement = 12798,
  SVGFEImageElement = 12823,
  SVGFEMergeElement = 12841,
  SVGFEMergeNodeElement = 12859,
  SVGFEMorphologyElement = 12881,
  SVGFEOffsetElement = 12904,
  SVGFEPointLightElement = 12923,
  SVGFESpecularLightingElement = 12946,
  SVGFESpotLightElement = 12975,
  SVGFETileElement = 12997,
  SVGFETurbulenceElement = 13014,
  SVGFilterElement = 13037,
  SVGForeignObjectElement = 13054,
  SVGGElement = 13078,
  SVGGeometryElement = 13090,
  SVGGradientElement = 13109,
  SVGGraphicsElement = 13128,
  SVGImageElement = 13147,
  SVGLength = 13163,
  SVGLengthList = 13173,
  SVGLineElement = 13187,
  SVGLinearGradientElement = 13202,
  SVGMPathElement = 13227,
  SVGMarkerElement = 13243,
  SVGMaskElement = 13260,
  SVGMatrix = 13275,
  SVGMetadataElement = 13285,
  SVGNumber = 13304,
  SVGNumberList = 13314,
  SVGPathElement = 13328,
  SVGPathSegment = 13343,
  SVGPatternElement = 13358,
  SVGPoint = 13376,
  SVGPointList = 13385,
  SVGPolygonElement = 13398,
  SVGPolylineElement = 13416,
  SVGPreserveAspectRatio = 13435,
  SVGRadialGradientElement = 13458,
  SVGRect = 13483,
  SVGRectElement = 13491,
  SVGSVGElement = 13506,
  SVGScriptElement = 13520,
  SVGSetElement = 13537,
  SVGStopElement = 13551,
  SVGStringList = 13566,
  SVGStyleElement = 13580,
  SVGSwitchElement = 13596,
  SVGSymbolElement = 13613,
  SVGTSpanElement = 13630,
  SVGTextContentElement = 13646,
  SVGTextElement = 13668,
  SVGTextPathElement = 13683,
  SVGTextPositioningElement = 13702,
  SVGTitleElement = 13728,
  SVGTransform = 13744,
  SVGTransformList = 13757,
  SVGUnitTypes = 13774,
  SVGUseElement = 13787,
  SVGViewElement = 13801,
  Sanitizer = 13816,
  Scheduler = 13826,
  Screen = 13836,
  ScreenLuminance = 13843,
  ScreenOrientation = 13859,
  ScriptProcessorNode = 13877,
  ScrollAreaEvent = 13897,
  SecurityPolicyViolationEvent = 13913,
  Selection = 13942,
  ServiceWorker = 13952,
  ServiceWorkerContainer = 13966,
  ServiceWorkerGlobalScope = 13989,
  ServiceWorkerRegistration = 14014,
  SessionStoreFormData = 14040,
  SessionStoreScrollData = 14061,
  SessionStoreUtils = 14084,
  ShadowRealmGlobalScope = 14102,
  ShadowRoot = 14125,
  SharedWorker = 14136,
  SharedWorkerGlobalScope = 14149,
  SimpleGestureEvent = 14173,
  SourceBuffer = 14192,
  SourceBufferList = 14205,
  SpeechGrammar = 14222,
  SpeechGrammarList = 14236,
  SpeechRecognition = 14254,
  SpeechRecognitionAlternative = 14272,
  SpeechRecognitionError = 14301,
  SpeechRecognitionEvent = 14324,
  SpeechRecognitionResult = 14347,
  SpeechRecognitionResultList = 14371,
  SpeechSynthesis = 14399,
  SpeechSynthesisErrorEvent = 14415,
  SpeechSynthesisEvent = 14441,
  SpeechSynthesisUtterance = 14462,
  SpeechSynthesisVoice = 14487,
  StaticRange = 14508,
  StereoPannerNode = 14520,
  Storage = 14537,
  StorageEvent = 14545,
  StorageManager = 14558,
  StreamFilter = 14573,
  StreamFilterDataEvent = 14586,
  StructuredCloneHolder = 14608,
  StructuredCloneTester = 14630,
  StyleSheet = 14652,
  StyleSheetApplicableStateChangeEvent = 14663,
  StyleSheetList = 14700,
  StyleSheetRemovedEvent = 14715,
  SubmitEvent = 14738,
  SubtleCrypto = 14750,
  SyncMessageSender = 14763,
  SyncReadFile = 14781,
  TCPServerSocket = 14794,
  TCPServerSocketEvent = 14810,
  TCPSocket = 14831,
  TCPSocketErrorEvent = 14841,
  TCPSocketEvent = 14861,
  TaskController = 14876,
  TaskPriorityChangeEvent = 14891,
  TaskSignal = 14915,
  TestUtils = 14926,
  TestingDeprecatedInterface = 14936,
  Text = 14963,
  TextClause = 14968,
  TextDecoder = 14979,
  TextDecoderStream = 14991,
  TextEncoder = 15009,
  TextEncoderStream = 15021,
  TextEvent = 15039,
  TextMetrics = 15049,
  TextTrack = 15061,
  TextTrackCue = 15071,
  TextTrackCueList = 15084,
  TextTrackList = 15101,
  TimeEvent = 15115,
  TimeRanges = 15125,
  ToggleEvent = 15136,
  Touch = 15148,
  TouchEvent = 15154,
  TouchList = 15165,
  TrackEvent = 15175,
  TransformStream = 15186,
  TransformStreamDefaultController = 15202,
  TransitionEvent = 15235,
  TreeColumn = 15251,
  TreeColumns = 15262,
  TreeContentView = 15274,
  TreeWalker = 15290,
  TrustedHTML = 15301,
  TrustedScript = 15313,
  TrustedScriptURL = 15327,
  TrustedTypePolicy = 15344,
  TrustedTypePolicyFactory = 15362,
  UDPMessageEvent = 15387,
  UDPSocket = 15403,
  UIEvent = 15413,
  URL = 15421,
  URLSearchParams = 15425,
  URLSearchParams_Iterator = 15441,
  UniFFIPointer = 15466,
  UniFFIScaffolding = 15480,
  UserActivation = 15498,
  UserInteraction = 15513,
  UserProximityEvent = 15529,
  VRDisplay = 15548,
  VRDisplayCapabilities = 15558,
  VRDisplayEvent = 15580,
  VREyeParameters = 15595,
  VRFieldOfView = 15611,
  VRFrameData = 15625,
  VRMockController = 15637,
  VRMockDisplay = 15654,
  VRPose = 15668,
  VRServiceTest = 15675,
  VRStageParameters = 15689,
  VTTCue = 15707,
  VTTRegion = 15714,
  ValidityState = 15724,
  VideoColorSpace = 15738,
  VideoDecoder = 15754,
  VideoEncoder = 15767,
  VideoFrame = 15780,
  VideoPlaybackQuality = 15791,
  VideoTrack = 15812,
  VideoTrackList = 15823,
  ViewTransition = 15838,
  VisualViewport = 15853,
  WEBGL_color_buffer_float = 15868,
  WEBGL_compressed_texture_astc = 15893,
  WEBGL_compressed_texture_etc = 15923,
  WEBGL_compressed_texture_etc1 = 15952,
  WEBGL_compressed_texture_pvrtc = 15982,
  WEBGL_compressed_texture_s3tc = 16013,
  WEBGL_compressed_texture_s3tc_srgb = 16043,
  WEBGL_debug_renderer_info = 16078,
  WEBGL_debug_shaders = 16104,
  WEBGL_depth_texture = 16124,
  WEBGL_draw_buffers = 16144,
  WEBGL_explicit_present = 16163,
  WEBGL_lose_context = 16186,
  WEBGL_provoking_vertex = 16205,
  WGSLLanguageFeatures = 16228,
  WakeLock = 16249,
  WakeLockSentinel = 16258,
  WaveShaperNode = 16275,
  WebExtensionContentScript = 16290,
  WebExtensionPolicy = 16316,
  WebGL2RenderingContext = 16335,
  WebGLActiveInfo = 16358,
  WebGLBuffer = 16374,
  WebGLContextEvent = 16386,
  WebGLFramebuffer = 16404,
  WebGLProgram = 16421,
  WebGLQuery = 16434,
  WebGLRenderbuffer = 16445,
  WebGLRenderingContext = 16463,
  WebGLSampler = 16485,
  WebGLShader = 16498,
  WebGLShaderPrecisionFormat = 16510,
  WebGLSync = 16537,
  WebGLTexture = 16547,
  WebGLTransformFeedback = 16560,
  WebGLUniformLocation = 16583,
  WebGLVertexArrayObject = 16604,
  WebKitCSSMatrix = 16627,
  WebSocket = 16643,
  WebTransport = 16653,
  WebTransportBidirectionalStream = 16666,
  WebTransportDatagramDuplexStream = 16698,
  WebTransportError = 16731,
  WebTransportReceiveStream = 16749,
  WebTransportSendStream = 16775,
  WebrtcGlobalInformation = 16798,
  WheelEvent = 16822,
  Window = 16833,
  WindowClient = 16840,
  WindowContext = 16853,
  WindowGlobalChild = 16867,
  WindowGlobalParent = 16885,
  WindowRoot = 16904,
  Worker = 16915,
  WorkerDebuggerGlobalScope = 16922,
  WorkerGlobalScope = 16948,
  WorkerLocation = 16966,
  WorkerNavigator = 16981,
  WorkerTestUtils = 16997,
  Worklet = 17013,
  WorkletGlobalScope = 17021,
  WritableStream = 17040,
  WritableStreamDefaultController = 17055,
  WritableStreamDefaultWriter = 17087,
  XMLDocument = 17115,
  XMLHttpRequest = 17127,
  XMLHttpRequestEventTarget = 17142,
  XMLHttpRequestUpload = 17168,
  XMLSerializer = 17189,
  XPathEvaluator = 17203,
  XPathExpression = 17218,
  XPathResult = 17234,
  XRBoundedReferenceSpace = 17246,
  XRFrame = 17270,
  XRInputSource = 17278,
  XRInputSourceArray = 17292,
  XRInputSourceEvent = 17311,
  XRInputSourcesChangeEvent = 17330,
  XRPose = 17356,
  XRReferenceSpace = 17363,
  XRReferenceSpaceEvent = 17380,
  XRRenderState = 17402,
  XRRigidTransform = 17416,
  XRSession = 17433,
  XRSessionEvent = 17443,
  XRSpace = 17458,
  XRSystem = 17466,
  XRView = 17475,
  XRViewerPose = 17482,
  XRViewport = 17495,
  XRWebGLLayer = 17506,
  XSLTProcessor = 17519,
  XULCommandEvent = 17533,
  XULElement = 17549,
  XULFrameElement = 17560,
  XULMenuElement = 17576,
  XULPopupElement = 17591,
  XULResizerElement = 17607,
  XULTextElement = 17625,
  XULTreeElement = 17640,
  console = 17655,
  webkitSpeechGrammar = 17663,
  webkitSpeechGrammarList = 17683,
  webkitSpeechRecognition = 17707,
  webkitURL = 17731,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
