/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/protocol/webtransport/nsIWebTransport.idl
 */

#ifndef __gen_nsIWebTransport_h__
#define __gen_nsIWebTransport_h__


#include "nsISupports.h"

#include "nsIURI.h"

#include "nsIPrincipal.h"

#include "nsTArray.h"

#include "js/GCAnnotations.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class WebTransportSessionEventListener; /* forward declaration */

class nsIWebTransportStreamCallback; /* forward declaration */

class nsIWebTransportBidirectionalStream; /* forward declaration */

class nsIWebTransportSendStream; /* forward declaration */

class nsIWebTransportReceiveStream; /* forward declaration */

class nsIWebTransportHash; /* forward declaration */

namespace mozilla::dom {
class ClientInfo;
}
namespace mozilla::net {
class Http3WebTransportSession;
class Http3WebTransportStream;
}

/* starting interface:    nsIWebTransport */
#define NS_IWEBTRANSPORT_IID_STR "c20d6e77-8cb1-4838-a88d-fff826080aa3"

#define NS_IWEBTRANSPORT_IID \
  {0xc20d6e77, 0x8cb1, 0x4838, \
    { 0xa8, 0x8d, 0xff, 0xf8, 0x26, 0x08, 0x0a, 0xa3 }}

class NS_NO_VTABLE nsIWebTransport : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IWEBTRANSPORT_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIWebTransport;

  enum WebTransportError : uint16_t {
    UNKNOWN_ERROR = 0,
    INVALID_STATE_ERROR = 1,
  };

  /* void asyncConnect (in nsIURI aURI, in boolean aDedicated, in Array<nsIWebTransportHash> aServerCertHashes, in nsIPrincipal aLoadingPrincipal, in unsigned long aSecurityFlags, in WebTransportSessionEventListener aListener); */
  NS_IMETHOD AsyncConnect(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener) = 0;

  /* [noscript] void asyncConnectWithClient (in nsIURI aURI, in boolean aDedicated, in Array<nsIWebTransportHash> aServerCertHashes, in nsIPrincipal aLoadingPrincipal, in unsigned long aSecurityFlags, in WebTransportSessionEventListener aListener, in const_MaybeClientInfoRef aClientInfo); */
  NS_IMETHOD AsyncConnectWithClient(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener, const mozilla::Maybe<mozilla::dom::ClientInfo> & aClientInfo) = 0;

  /* void getStats (); */
  NS_IMETHOD GetStats(void) = 0;

  /* void closeSession (in uint32_t aErrorCode, in ACString aReason); */
  NS_IMETHOD CloseSession(uint32_t aErrorCode, const nsACString& aReason) = 0;

  /* void createOutgoingBidirectionalStream (in nsIWebTransportStreamCallback aListener); */
  NS_IMETHOD CreateOutgoingBidirectionalStream(nsIWebTransportStreamCallback *aListener) = 0;

  /* void createOutgoingUnidirectionalStream (in nsIWebTransportStreamCallback aListener); */
  NS_IMETHOD CreateOutgoingUnidirectionalStream(nsIWebTransportStreamCallback *aListener) = 0;

  /* void sendDatagram (in Array<uint8_t> aData, in uint64_t aTrackingId); */
  NS_IMETHOD SendDatagram(const nsTArray<uint8_t >& aData, uint64_t aTrackingId) = 0;

  /* void getMaxDatagramSize (); */
  NS_IMETHOD GetMaxDatagramSize(void) = 0;

  /* [noscript] void retargetTo (in nsIEventTarget aTarget); */
  NS_IMETHOD RetargetTo(nsIEventTarget *aTarget) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIWebTransport, NS_IWEBTRANSPORT_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIWEBTRANSPORT \
  NS_IMETHOD AsyncConnect(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener) override; \
  NS_IMETHOD AsyncConnectWithClient(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener, const mozilla::Maybe<mozilla::dom::ClientInfo> & aClientInfo) override; \
  NS_IMETHOD GetStats(void) override; \
  NS_IMETHOD CloseSession(uint32_t aErrorCode, const nsACString& aReason) override; \
  NS_IMETHOD CreateOutgoingBidirectionalStream(nsIWebTransportStreamCallback *aListener) override; \
  NS_IMETHOD CreateOutgoingUnidirectionalStream(nsIWebTransportStreamCallback *aListener) override; \
  NS_IMETHOD SendDatagram(const nsTArray<uint8_t >& aData, uint64_t aTrackingId) override; \
  NS_IMETHOD GetMaxDatagramSize(void) override; \
  NS_IMETHOD RetargetTo(nsIEventTarget *aTarget) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIWEBTRANSPORT \
  nsresult AsyncConnect(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener); \
  nsresult AsyncConnectWithClient(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener, const mozilla::Maybe<mozilla::dom::ClientInfo> & aClientInfo); \
  nsresult GetStats(void); \
  nsresult CloseSession(uint32_t aErrorCode, const nsACString& aReason); \
  nsresult CreateOutgoingBidirectionalStream(nsIWebTransportStreamCallback *aListener); \
  nsresult CreateOutgoingUnidirectionalStream(nsIWebTransportStreamCallback *aListener); \
  nsresult SendDatagram(const nsTArray<uint8_t >& aData, uint64_t aTrackingId); \
  nsresult GetMaxDatagramSize(void); \
  nsresult RetargetTo(nsIEventTarget *aTarget); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIWEBTRANSPORT(_to) \
  NS_IMETHOD AsyncConnect(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener) override { return _to AsyncConnect(aURI, aDedicated, aServerCertHashes, aLoadingPrincipal, aSecurityFlags, aListener); } \
  NS_IMETHOD AsyncConnectWithClient(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener, const mozilla::Maybe<mozilla::dom::ClientInfo> & aClientInfo) override { return _to AsyncConnectWithClient(aURI, aDedicated, aServerCertHashes, aLoadingPrincipal, aSecurityFlags, aListener, aClientInfo); } \
  NS_IMETHOD GetStats(void) override { return _to GetStats(); } \
  NS_IMETHOD CloseSession(uint32_t aErrorCode, const nsACString& aReason) override { return _to CloseSession(aErrorCode, aReason); } \
  NS_IMETHOD CreateOutgoingBidirectionalStream(nsIWebTransportStreamCallback *aListener) override { return _to CreateOutgoingBidirectionalStream(aListener); } \
  NS_IMETHOD CreateOutgoingUnidirectionalStream(nsIWebTransportStreamCallback *aListener) override { return _to CreateOutgoingUnidirectionalStream(aListener); } \
  NS_IMETHOD SendDatagram(const nsTArray<uint8_t >& aData, uint64_t aTrackingId) override { return _to SendDatagram(aData, aTrackingId); } \
  NS_IMETHOD GetMaxDatagramSize(void) override { return _to GetMaxDatagramSize(); } \
  NS_IMETHOD RetargetTo(nsIEventTarget *aTarget) override { return _to RetargetTo(aTarget); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIWEBTRANSPORT(_to) \
  NS_IMETHOD AsyncConnect(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncConnect(aURI, aDedicated, aServerCertHashes, aLoadingPrincipal, aSecurityFlags, aListener); } \
  NS_IMETHOD AsyncConnectWithClient(nsIURI *aURI, bool aDedicated, const nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes, nsIPrincipal *aLoadingPrincipal, uint32_t aSecurityFlags, WebTransportSessionEventListener *aListener, const mozilla::Maybe<mozilla::dom::ClientInfo> & aClientInfo) override { return !_to ? NS_ERROR_NULL_POINTER : _to->AsyncConnectWithClient(aURI, aDedicated, aServerCertHashes, aLoadingPrincipal, aSecurityFlags, aListener, aClientInfo); } \
  NS_IMETHOD GetStats(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetStats(); } \
  NS_IMETHOD CloseSession(uint32_t aErrorCode, const nsACString& aReason) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CloseSession(aErrorCode, aReason); } \
  NS_IMETHOD CreateOutgoingBidirectionalStream(nsIWebTransportStreamCallback *aListener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateOutgoingBidirectionalStream(aListener); } \
  NS_IMETHOD CreateOutgoingUnidirectionalStream(nsIWebTransportStreamCallback *aListener) override { return !_to ? NS_ERROR_NULL_POINTER : _to->CreateOutgoingUnidirectionalStream(aListener); } \
  NS_IMETHOD SendDatagram(const nsTArray<uint8_t >& aData, uint64_t aTrackingId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SendDatagram(aData, aTrackingId); } \
  NS_IMETHOD GetMaxDatagramSize(void) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetMaxDatagramSize(); } \
  NS_IMETHOD RetargetTo(nsIEventTarget *aTarget) override { return !_to ? NS_ERROR_NULL_POINTER : _to->RetargetTo(aTarget); } 


/* starting interface:    WebTransportSessionEventListener */
#define WEBTRANSPORTSESSIONEVENTLISTENER_IID_STR "0e3cb269-f318-43c8-959e-897f57894b71"

#define WEBTRANSPORTSESSIONEVENTLISTENER_IID \
  {0x0e3cb269, 0xf318, 0x43c8, \
    { 0x95, 0x9e, 0x89, 0x7f, 0x57, 0x89, 0x4b, 0x71 }}

class NS_NO_VTABLE WebTransportSessionEventListener : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(WEBTRANSPORTSESSIONEVENTLISTENER_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = WebTransportSessionEventListener;

  /* void onSessionReady (in uint64_t aSessionId); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnSessionReady(uint64_t aSessionId) = 0;

  /* void onSessionClosed (in boolean aCleanly, in uint32_t aErrorCode, in ACString aReason); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnSessionClosed(bool aCleanly, uint32_t aErrorCode, const nsACString& aReason) = 0;

  /* void onIncomingBidirectionalStreamAvailable (in nsIWebTransportBidirectionalStream aStream); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnIncomingBidirectionalStreamAvailable(nsIWebTransportBidirectionalStream *aStream) = 0;

  /* void onIncomingUnidirectionalStreamAvailable (in nsIWebTransportReceiveStream aStream); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnIncomingUnidirectionalStreamAvailable(nsIWebTransportReceiveStream *aStream) = 0;

  /* void onStopSending (in uint64_t aStreamId, in nsresult aError); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnStopSending(uint64_t aStreamId, nsresult aError) = 0;

  /* void onResetReceived (in uint64_t aStreamId, in nsresult aError); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnResetReceived(uint64_t aStreamId, nsresult aError) = 0;

  /* void onDatagramReceived (in Array<uint8_t> aData); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnDatagramReceived(const nsTArray<uint8_t >& aData) = 0;

  /* void onMaxDatagramSize (in uint64_t aSize); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnMaxDatagramSize(uint64_t aSize) = 0;

  enum DatagramOutcome : uint32_t {
    UNKNOWN = 0,
    DROPPED_TOO_MUCH_DATA = 1,
    SENT = 2,
  };

  /* void onOutgoingDatagramOutCome (in uint64_t aId, in WebTransportSessionEventListener_DatagramOutcome aOutCome); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnOutgoingDatagramOutCome(uint64_t aId, WebTransportSessionEventListener::DatagramOutcome aOutCome) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(WebTransportSessionEventListener, WEBTRANSPORTSESSIONEVENTLISTENER_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_WEBTRANSPORTSESSIONEVENTLISTENER \
  NS_IMETHOD OnSessionReady(uint64_t aSessionId) override; \
  NS_IMETHOD OnSessionClosed(bool aCleanly, uint32_t aErrorCode, const nsACString& aReason) override; \
  NS_IMETHOD OnIncomingBidirectionalStreamAvailable(nsIWebTransportBidirectionalStream *aStream) override; \
  NS_IMETHOD OnIncomingUnidirectionalStreamAvailable(nsIWebTransportReceiveStream *aStream) override; \
  NS_IMETHOD OnStopSending(uint64_t aStreamId, nsresult aError) override; \
  NS_IMETHOD OnResetReceived(uint64_t aStreamId, nsresult aError) override; \
  NS_IMETHOD OnDatagramReceived(const nsTArray<uint8_t >& aData) override; \
  NS_IMETHOD OnMaxDatagramSize(uint64_t aSize) override; \
  NS_IMETHOD OnOutgoingDatagramOutCome(uint64_t aId, WebTransportSessionEventListener::DatagramOutcome aOutCome) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_WEBTRANSPORTSESSIONEVENTLISTENER \
  nsresult OnSessionReady(uint64_t aSessionId); \
  nsresult OnSessionClosed(bool aCleanly, uint32_t aErrorCode, const nsACString& aReason); \
  nsresult OnIncomingBidirectionalStreamAvailable(nsIWebTransportBidirectionalStream *aStream); \
  nsresult OnIncomingUnidirectionalStreamAvailable(nsIWebTransportReceiveStream *aStream); \
  nsresult OnStopSending(uint64_t aStreamId, nsresult aError); \
  nsresult OnResetReceived(uint64_t aStreamId, nsresult aError); \
  nsresult OnDatagramReceived(const nsTArray<uint8_t >& aData); \
  nsresult OnMaxDatagramSize(uint64_t aSize); \
  nsresult OnOutgoingDatagramOutCome(uint64_t aId, WebTransportSessionEventListener::DatagramOutcome aOutCome); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_WEBTRANSPORTSESSIONEVENTLISTENER(_to) \
  NS_IMETHOD OnSessionReady(uint64_t aSessionId) override { return _to OnSessionReady(aSessionId); } \
  NS_IMETHOD OnSessionClosed(bool aCleanly, uint32_t aErrorCode, const nsACString& aReason) override { return _to OnSessionClosed(aCleanly, aErrorCode, aReason); } \
  NS_IMETHOD OnIncomingBidirectionalStreamAvailable(nsIWebTransportBidirectionalStream *aStream) override { return _to OnIncomingBidirectionalStreamAvailable(aStream); } \
  NS_IMETHOD OnIncomingUnidirectionalStreamAvailable(nsIWebTransportReceiveStream *aStream) override { return _to OnIncomingUnidirectionalStreamAvailable(aStream); } \
  NS_IMETHOD OnStopSending(uint64_t aStreamId, nsresult aError) override { return _to OnStopSending(aStreamId, aError); } \
  NS_IMETHOD OnResetReceived(uint64_t aStreamId, nsresult aError) override { return _to OnResetReceived(aStreamId, aError); } \
  NS_IMETHOD OnDatagramReceived(const nsTArray<uint8_t >& aData) override { return _to OnDatagramReceived(aData); } \
  NS_IMETHOD OnMaxDatagramSize(uint64_t aSize) override { return _to OnMaxDatagramSize(aSize); } \
  NS_IMETHOD OnOutgoingDatagramOutCome(uint64_t aId, WebTransportSessionEventListener::DatagramOutcome aOutCome) override { return _to OnOutgoingDatagramOutCome(aId, aOutCome); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_WEBTRANSPORTSESSIONEVENTLISTENER(_to) \
  NS_IMETHOD OnSessionReady(uint64_t aSessionId) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnSessionReady(aSessionId); } \
  NS_IMETHOD OnSessionClosed(bool aCleanly, uint32_t aErrorCode, const nsACString& aReason) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnSessionClosed(aCleanly, aErrorCode, aReason); } \
  NS_IMETHOD OnIncomingBidirectionalStreamAvailable(nsIWebTransportBidirectionalStream *aStream) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnIncomingBidirectionalStreamAvailable(aStream); } \
  NS_IMETHOD OnIncomingUnidirectionalStreamAvailable(nsIWebTransportReceiveStream *aStream) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnIncomingUnidirectionalStreamAvailable(aStream); } \
  NS_IMETHOD OnStopSending(uint64_t aStreamId, nsresult aError) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnStopSending(aStreamId, aError); } \
  NS_IMETHOD OnResetReceived(uint64_t aStreamId, nsresult aError) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnResetReceived(aStreamId, aError); } \
  NS_IMETHOD OnDatagramReceived(const nsTArray<uint8_t >& aData) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDatagramReceived(aData); } \
  NS_IMETHOD OnMaxDatagramSize(uint64_t aSize) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnMaxDatagramSize(aSize); } \
  NS_IMETHOD OnOutgoingDatagramOutCome(uint64_t aId, WebTransportSessionEventListener::DatagramOutcome aOutCome) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnOutgoingDatagramOutCome(aId, aOutCome); } 


/* starting interface:    WebTransportSessionEventListenerInternal */
#define WEBTRANSPORTSESSIONEVENTLISTENERINTERNAL_IID_STR "8fb30aa9-5163-4eb3-81f3-371e1ccb5b0e"

#define WEBTRANSPORTSESSIONEVENTLISTENERINTERNAL_IID \
  {0x8fb30aa9, 0x5163, 0x4eb3, \
    { 0x81, 0xf3, 0x37, 0x1e, 0x1c, 0xcb, 0x5b, 0x0e }}

class NS_NO_VTABLE WebTransportSessionEventListenerInternal : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(WEBTRANSPORTSESSIONEVENTLISTENERINTERNAL_IID)

  /* void onSessionReadyInternal (in Http3WebTransportSessionPtr aSession); */
  NS_IMETHOD OnSessionReadyInternal(mozilla::net::Http3WebTransportSession * aSession) = 0;

  /* void onIncomingStreamAvailableInternal (in Http3WebTransportStreamPtr aStream); */
  NS_IMETHOD OnIncomingStreamAvailableInternal(mozilla::net::Http3WebTransportStream * aStream) = 0;

  /* void onDatagramReceivedInternal (in Datagram aData); */
  NS_IMETHOD OnDatagramReceivedInternal(nsTArray<uint8_t>&& aData) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(WebTransportSessionEventListenerInternal, WEBTRANSPORTSESSIONEVENTLISTENERINTERNAL_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_WEBTRANSPORTSESSIONEVENTLISTENERINTERNAL \
  NS_IMETHOD OnSessionReadyInternal(mozilla::net::Http3WebTransportSession * aSession) override; \
  NS_IMETHOD OnIncomingStreamAvailableInternal(mozilla::net::Http3WebTransportStream * aStream) override; \
  NS_IMETHOD OnDatagramReceivedInternal(nsTArray<uint8_t>&& aData) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_WEBTRANSPORTSESSIONEVENTLISTENERINTERNAL \
  nsresult OnSessionReadyInternal(mozilla::net::Http3WebTransportSession * aSession); \
  nsresult OnIncomingStreamAvailableInternal(mozilla::net::Http3WebTransportStream * aStream); \
  nsresult OnDatagramReceivedInternal(nsTArray<uint8_t>&& aData); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_WEBTRANSPORTSESSIONEVENTLISTENERINTERNAL(_to) \
  NS_IMETHOD OnSessionReadyInternal(mozilla::net::Http3WebTransportSession * aSession) override { return _to OnSessionReadyInternal(aSession); } \
  NS_IMETHOD OnIncomingStreamAvailableInternal(mozilla::net::Http3WebTransportStream * aStream) override { return _to OnIncomingStreamAvailableInternal(aStream); } \
  NS_IMETHOD OnDatagramReceivedInternal(nsTArray<uint8_t>&& aData) override { return _to OnDatagramReceivedInternal(aData); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_WEBTRANSPORTSESSIONEVENTLISTENERINTERNAL(_to) \
  NS_IMETHOD OnSessionReadyInternal(mozilla::net::Http3WebTransportSession * aSession) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnSessionReadyInternal(aSession); } \
  NS_IMETHOD OnIncomingStreamAvailableInternal(mozilla::net::Http3WebTransportStream * aStream) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnIncomingStreamAvailableInternal(aStream); } \
  NS_IMETHOD OnDatagramReceivedInternal(nsTArray<uint8_t>&& aData) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnDatagramReceivedInternal(aData); } 


/* starting interface:    WebTransportConnectionSettings */
#define WEBTRANSPORTCONNECTIONSETTINGS_IID_STR "faad75bd-83c6-420b-9fdb-a70bd70be449"

#define WEBTRANSPORTCONNECTIONSETTINGS_IID \
  {0xfaad75bd, 0x83c6, 0x420b, \
    { 0x9f, 0xdb, 0xa7, 0x0b, 0xd7, 0x0b, 0xe4, 0x49 }}

class NS_NO_VTABLE WebTransportConnectionSettings : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(WEBTRANSPORTCONNECTIONSETTINGS_IID)

  /* readonly attribute boolean dedicated; */
  NS_IMETHOD GetDedicated(bool *aDedicated) = 0;

  /* void getServerCertificateHashes (out Array<nsIWebTransportHash> aServerCertHashes); */
  NS_IMETHOD GetServerCertificateHashes(nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(WebTransportConnectionSettings, WEBTRANSPORTCONNECTIONSETTINGS_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_WEBTRANSPORTCONNECTIONSETTINGS \
  NS_IMETHOD GetDedicated(bool *aDedicated) override; \
  NS_IMETHOD GetServerCertificateHashes(nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_WEBTRANSPORTCONNECTIONSETTINGS \
  nsresult GetDedicated(bool *aDedicated); \
  nsresult GetServerCertificateHashes(nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_WEBTRANSPORTCONNECTIONSETTINGS(_to) \
  NS_IMETHOD GetDedicated(bool *aDedicated) override { return _to GetDedicated(aDedicated); } \
  NS_IMETHOD GetServerCertificateHashes(nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes) override { return _to GetServerCertificateHashes(aServerCertHashes); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_WEBTRANSPORTCONNECTIONSETTINGS(_to) \
  NS_IMETHOD GetDedicated(bool *aDedicated) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetDedicated(aDedicated); } \
  NS_IMETHOD GetServerCertificateHashes(nsTArray<RefPtr<nsIWebTransportHash>>& aServerCertHashes) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetServerCertificateHashes(aServerCertHashes); } 


/* starting interface:    nsIWebTransportStreamCallback */
#define NS_IWEBTRANSPORTSTREAMCALLBACK_IID_STR "c6eeff1d-599b-40a8-9157-c7a40c3d51a2"

#define NS_IWEBTRANSPORTSTREAMCALLBACK_IID \
  {0xc6eeff1d, 0x599b, 0x40a8, \
    { 0x91, 0x57, 0xc7, 0xa4, 0x0c, 0x3d, 0x51, 0xa2 }}

class NS_NO_VTABLE nsIWebTransportStreamCallback : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IWEBTRANSPORTSTREAMCALLBACK_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIWebTransportStreamCallback;

  /* void onBidirectionalStreamReady (in nsIWebTransportBidirectionalStream aStream); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnBidirectionalStreamReady(nsIWebTransportBidirectionalStream *aStream) = 0;

  /* void onUnidirectionalStreamReady (in nsIWebTransportSendStream aStream); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnUnidirectionalStreamReady(nsIWebTransportSendStream *aStream) = 0;

  /* void onError (in uint8_t aError); */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD OnError(uint8_t aError) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIWebTransportStreamCallback, NS_IWEBTRANSPORTSTREAMCALLBACK_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIWEBTRANSPORTSTREAMCALLBACK \
  NS_IMETHOD OnBidirectionalStreamReady(nsIWebTransportBidirectionalStream *aStream) override; \
  NS_IMETHOD OnUnidirectionalStreamReady(nsIWebTransportSendStream *aStream) override; \
  NS_IMETHOD OnError(uint8_t aError) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIWEBTRANSPORTSTREAMCALLBACK \
  nsresult OnBidirectionalStreamReady(nsIWebTransportBidirectionalStream *aStream); \
  nsresult OnUnidirectionalStreamReady(nsIWebTransportSendStream *aStream); \
  nsresult OnError(uint8_t aError); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIWEBTRANSPORTSTREAMCALLBACK(_to) \
  NS_IMETHOD OnBidirectionalStreamReady(nsIWebTransportBidirectionalStream *aStream) override { return _to OnBidirectionalStreamReady(aStream); } \
  NS_IMETHOD OnUnidirectionalStreamReady(nsIWebTransportSendStream *aStream) override { return _to OnUnidirectionalStreamReady(aStream); } \
  NS_IMETHOD OnError(uint8_t aError) override { return _to OnError(aError); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIWEBTRANSPORTSTREAMCALLBACK(_to) \
  NS_IMETHOD OnBidirectionalStreamReady(nsIWebTransportBidirectionalStream *aStream) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnBidirectionalStreamReady(aStream); } \
  NS_IMETHOD OnUnidirectionalStreamReady(nsIWebTransportSendStream *aStream) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnUnidirectionalStreamReady(aStream); } \
  NS_IMETHOD OnError(uint8_t aError) override { return !_to ? NS_ERROR_NULL_POINTER : _to->OnError(aError); } 


/* starting interface:    nsIWebTransportHash */
#define NS_IWEBTRANSPORTHASH_IID_STR "2523a26e-94be-4de6-8c27-9b4ffff742f0"

#define NS_IWEBTRANSPORTHASH_IID \
  {0x2523a26e, 0x94be, 0x4de6, \
    { 0x8c, 0x27, 0x9b, 0x4f, 0xff, 0xf7, 0x42, 0xf0 }}

class NS_NO_VTABLE nsIWebTransportHash : public nsISupports {
 public:

  NS_DECLARE_STATIC_IID_ACCESSOR(NS_IWEBTRANSPORTHASH_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIWebTransportHash;

  /* readonly attribute ACString algorithm; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetAlgorithm(nsACString& aAlgorithm) = 0;

  /* readonly attribute Array<uint8_t> value; */
  JS_HAZ_CAN_RUN_SCRIPT NS_IMETHOD GetValue(nsTArray<uint8_t >& aValue) = 0;

};

  NS_DEFINE_STATIC_IID_ACCESSOR(nsIWebTransportHash, NS_IWEBTRANSPORTHASH_IID)

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIWEBTRANSPORTHASH \
  NS_IMETHOD GetAlgorithm(nsACString& aAlgorithm) override; \
  NS_IMETHOD GetValue(nsTArray<uint8_t >& aValue) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIWEBTRANSPORTHASH \
  nsresult GetAlgorithm(nsACString& aAlgorithm); \
  nsresult GetValue(nsTArray<uint8_t >& aValue); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIWEBTRANSPORTHASH(_to) \
  NS_IMETHOD GetAlgorithm(nsACString& aAlgorithm) override { return _to GetAlgorithm(aAlgorithm); } \
  NS_IMETHOD GetValue(nsTArray<uint8_t >& aValue) override { return _to GetValue(aValue); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIWEBTRANSPORTHASH(_to) \
  NS_IMETHOD GetAlgorithm(nsACString& aAlgorithm) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetAlgorithm(aAlgorithm); } \
  NS_IMETHOD GetValue(nsTArray<uint8_t >& aValue) override { return !_to ? NS_ERROR_NULL_POINTER : _to->GetValue(aValue); } 


#endif /* __gen_nsIWebTransport_h__ */
