/* THIS FILE IS AUTOGENERATED FROM L10nRegistry.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_L10NREGISTRYBINDING_H_
#define DOM_L10NREGISTRYBINDING_H_

#include "FluentBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"
#include "mozilla/intl/FluentBundle.h"

namespace mozilla {

namespace dom {

struct FileSourceOptionsAtoms;
struct FluentBundleAddResourceOptions;
struct FluentBundleIteratorResultAtoms;
struct FluentBundleOptions;
struct L10nFileSourceMockFileAtoms;
struct L10nRegistryOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct ResourceIdAtoms;

} // namespace dom

namespace intl {

class FluentBundle;
class FluentBundleAsyncIterator;
class FluentBundleIterator;
class L10nFileSource;
class L10nRegistry;

} // namespace intl

} // namespace mozilla

namespace mozilla {

namespace dom {

enum class L10nFileSourceHasFileStatus : uint8_t {
  Present,
  Missing,
  Unknown,
};

namespace binding_detail {
template <> struct EnumStrings<L10nFileSourceHasFileStatus> {
  static const nsLiteralCString Values[3];
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, L10nFileSourceHasFileStatus aArgument, JS::MutableHandle<JS::Value> aValue);


struct FileSourceOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR FluentBundleAddResourceOptions mAddResourceOptions;

  FileSourceOptions();

  explicit inline FileSourceOptions(const FastDictionaryInitializer& )
    : mAddResourceOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FileSourceOptions(FileSourceOptions&& aOther) = default;

  explicit inline FileSourceOptions(const FileSourceOptions& aOther)
    : mAddResourceOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  FileSourceOptions&
  operator=(const FileSourceOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, FileSourceOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastFileSourceOptions : public FileSourceOptions
{
  inline FastFileSourceOptions()
    : FileSourceOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct FluentBundleIteratorResult : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mDone;
  MOZ_INIT_OUTSIDE_CTOR RefPtr<mozilla::intl::FluentBundle> mValue;

  FluentBundleIteratorResult();

  explicit inline FluentBundleIteratorResult(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FluentBundleIteratorResult(FluentBundleIteratorResult&& aOther) = default;

  explicit inline FluentBundleIteratorResult(const FluentBundleIteratorResult& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mValue, "mValue", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mValue);
  }

  FluentBundleIteratorResult&
  operator=(const FluentBundleIteratorResult& aOther);

private:
  static bool
  InitIds(JSContext* cx, FluentBundleIteratorResultAtoms* atomsCache);
};

namespace binding_detail {
struct FastFluentBundleIteratorResult : public FluentBundleIteratorResult
{
  inline FastFluentBundleIteratorResult()
    : FluentBundleIteratorResult(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct L10nFileSourceMockFile : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR nsCString mPath;
  MOZ_INIT_OUTSIDE_CTOR nsCString mSource;

  L10nFileSourceMockFile();

  explicit inline L10nFileSourceMockFile(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  L10nFileSourceMockFile(L10nFileSourceMockFile&& aOther) = default;

  explicit inline L10nFileSourceMockFile(const L10nFileSourceMockFile& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  L10nFileSourceMockFile&
  operator=(const L10nFileSourceMockFile& aOther);

private:
  static bool
  InitIds(JSContext* cx, L10nFileSourceMockFileAtoms* atomsCache);
};

namespace binding_detail {
struct FastL10nFileSourceMockFile : public L10nFileSourceMockFile
{
  inline FastL10nFileSourceMockFile()
    : L10nFileSourceMockFile(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct L10nRegistryOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR FluentBundleOptions mBundleOptions;

  L10nRegistryOptions();

  explicit inline L10nRegistryOptions(const FastDictionaryInitializer& )
    : mBundleOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  L10nRegistryOptions(L10nRegistryOptions&& aOther) = default;

  explicit inline L10nRegistryOptions(const L10nRegistryOptions& aOther)
    : mBundleOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  L10nRegistryOptions&
  operator=(const L10nRegistryOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, L10nRegistryOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastL10nRegistryOptions : public L10nRegistryOptions
{
  inline FastL10nRegistryOptions()
    : L10nRegistryOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ResourceId : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mOptional;
  MOZ_INIT_OUTSIDE_CTOR nsCString mPath;

  ResourceId();

  explicit inline ResourceId(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ResourceId(ResourceId&& aOther) = default;

  explicit inline ResourceId(const ResourceId& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ResourceId&
  operator=(const ResourceId& aOther);

private:
  static bool
  InitIds(JSContext* cx, ResourceIdAtoms* atomsCache);
};

namespace binding_detail {
struct FastResourceId : public ResourceId
{
  inline FastResourceId()
    : ResourceId(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UTF8StringOrResourceId : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eResourceId
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eResourceId = TypeOrUninit::eResourceId
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<binding_detail::FastResourceId > mResourceId;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrResourceId(const UTF8StringOrResourceId&) = delete;
  UTF8StringOrResourceId& operator=(const UTF8StringOrResourceId&) = delete;
public:
  explicit inline UTF8StringOrResourceId()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrResourceId()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] inline binding_detail::FastResourceId&
  RawSetAsResourceId()
  {
    if (mType == eResourceId) {
      return mValue.mResourceId.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eResourceId;
    return mValue.mResourceId.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastResourceId&
  SetAsResourceId()
  {
    if (mType == eResourceId) {
      return mValue.mResourceId.Value();
    }
    Uninit();
    mType = eResourceId;
    return mValue.mResourceId.SetValue();
  }

  inline bool
  IsResourceId() const
  {
    return mType == eResourceId;
  }

  inline binding_detail::FastResourceId&
  GetAsResourceId()
  {
    MOZ_RELEASE_ASSERT(IsResourceId(), "Wrong type!");
    return mValue.mResourceId.Value();
  }

  inline const ResourceId&
  GetAsResourceId() const
  {
    MOZ_RELEASE_ASSERT(IsResourceId(), "Wrong type!");
    return mValue.mResourceId.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eResourceId: {
        DestroyResourceId();
        break;
      }
    }
  }

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToResourceId(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToResourceId(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyResourceId()
  {
    MOZ_RELEASE_ASSERT(IsResourceId(), "Wrong type!");
    mValue.mResourceId.Destroy();
    mType = eUninitialized;
  }
};


class OwningUTF8StringOrResourceId : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eResourceId
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eResourceId = TypeOrUninit::eResourceId
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<ResourceId > mResourceId;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningUTF8StringOrResourceId()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrResourceId(OwningUTF8StringOrResourceId&& aOther);

  explicit inline OwningUTF8StringOrResourceId(const OwningUTF8StringOrResourceId& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningUTF8StringOrResourceId()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] ResourceId&
  RawSetAsResourceId();

  [[nodiscard]] ResourceId&
  SetAsResourceId();

  inline bool
  IsResourceId() const
  {
    return mType == eResourceId;
  }

  inline ResourceId&
  GetAsResourceId()
  {
    MOZ_RELEASE_ASSERT(IsResourceId(), "Wrong type!");
    return mValue.mResourceId.Value();
  }

  inline ResourceId const &
  GetAsResourceId() const
  {
    MOZ_RELEASE_ASSERT(IsResourceId(), "Wrong type!");
    return mValue.mResourceId.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningUTF8StringOrResourceId&
  operator=(OwningUTF8StringOrResourceId&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningUTF8StringOrResourceId&
  operator=(const OwningUTF8StringOrResourceId& aOther);

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToResourceId(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToResourceId(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyResourceId();
};


namespace FluentBundleAsyncIterator_Binding {

  typedef mozilla::intl::FluentBundleAsyncIterator NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::intl::FluentBundleAsyncIterator* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::FluentBundleAsyncIterator,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

} // namespace FluentBundleAsyncIterator_Binding



namespace FluentBundleIterator_Binding {

  typedef mozilla::intl::FluentBundleIterator NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::intl::FluentBundleIterator* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::FluentBundleIterator,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

} // namespace FluentBundleIterator_Binding



namespace L10nFileSource_Binding {

  typedef mozilla::intl::L10nFileSource NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::intl::L10nFileSource* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedLocalesValue(mozilla::intl::L10nFileSource* aObject);

  void
  ClearCachedIndexValue(mozilla::intl::L10nFileSource* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::L10nFileSource,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::L10nFileSource,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::L10nFileSource,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace L10nFileSource_Binding



namespace L10nRegistry_Binding {

  typedef mozilla::intl::L10nRegistry NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::intl::L10nRegistry* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::L10nRegistry,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::L10nRegistry,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::L10nRegistry,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace L10nRegistry_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::L10nFileSourceHasFileStatus>
{
  static constexpr dom::L10nFileSourceHasFileStatus value = dom::L10nFileSourceHasFileStatus::Unknown;

  static_assert(static_cast<uint8_t>(dom::L10nFileSourceHasFileStatus::Present) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(mozilla::ArrayLength(dom::binding_detail::EnumStrings<dom::L10nFileSourceHasFileStatus>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_L10NREGISTRYBINDING_H_
