/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.metrics.descriptorparser.parsers;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.torproject.descriptor.BridgestrapStats;
import org.torproject.descriptor.BridgestrapTestResult;
import org.torproject.descriptor.Descriptor;
import org.torproject.descriptor.DescriptorReader;
import org.torproject.descriptor.DescriptorSourceFactory;
import org.torproject.metrics.descriptorparser.utils.DescriptorUtils;

public class BridgestrapParser {
    private static final String INSERT_BRIDGESTRAP_STATS_SQL = "INSERT INTO bridgestrap_stats (bridgestrap_stats_end, interval, digest, cached_requests, header) VALUES (?, ?, ?, ?, ?)";
    private static final String INSERT_BRIDGESTRAP_TEST_SQL = "INSERT INTO bridgestrap_test (digest, published, result, fingerprint, bridgestrap_stats) VALUES (?, ?, ?, ?, ?)";
    private static final Logger logger = LoggerFactory.getLogger(BridgestrapParser.class);

    public void run(String path, Connection conn) throws Exception {
        DescriptorUtils descUtils = new DescriptorUtils();
        DescriptorReader descriptorReader = DescriptorSourceFactory.createDescriptorReader();
        for (Descriptor descriptor : descriptorReader.readDescriptors(new File(path))) {
            if (!(descriptor instanceof BridgestrapStats)) continue;
            BridgestrapStats desc = (BridgestrapStats)descriptor;
            String digest = descUtils.calculateDigestSha256Base64(desc.getRawDescriptorBytes());
            this.addBridgestrapStats(desc, digest, conn);
            if (!desc.bridgestrapTests().isPresent()) continue;
            for (BridgestrapTestResult testResult : desc.bridgestrapTests().get()) {
                this.addBridgestrapTest(desc.bridgestrapStatsEnd(), testResult, digest, conn);
            }
        }
    }

    private void addBridgestrapStats(BridgestrapStats desc, String digest, Connection conn) {
        try (PreparedStatement preparedStatement = conn.prepareStatement(INSERT_BRIDGESTRAP_STATS_SQL);){
            Timestamp timestamp = Timestamp.valueOf(desc.bridgestrapStatsEnd());
            preparedStatement.setTimestamp(1, timestamp);
            preparedStatement.setLong(2, desc.bridgestrapStatsIntervalLength().getSeconds());
            preparedStatement.setString(3, digest);
            preparedStatement.setInt(4, desc.bridgestrapCachedRequests());
            preparedStatement.setString(5, "@type bridgestrap-stats 1.0");
            preparedStatement.executeUpdate();
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }

    private void addBridgestrapTest(LocalDateTime bridgestrapStatsEnd, BridgestrapTestResult testResult, String digest, Connection conn) {
        DescriptorUtils descUtils = new DescriptorUtils();
        try (PreparedStatement preparedStatement = conn.prepareStatement(INSERT_BRIDGESTRAP_TEST_SQL);){
            Timestamp timestamp = Timestamp.valueOf(bridgestrapStatsEnd);
            String digestLine = descUtils.fieldAsString(testResult);
            preparedStatement.setString(1, descUtils.calculateDigestSha256Base64(digestLine.getBytes()));
            preparedStatement.setTimestamp(2, timestamp);
            preparedStatement.setBoolean(3, testResult.isReachable());
            preparedStatement.setString(4, testResult.hashedFingerprint().get());
            preparedStatement.setString(5, digest);
            preparedStatement.executeUpdate();
        }
        catch (Exception ex) {
            logger.warn(String.format(ex.getMessage(), new Object[0]));
        }
    }
}

